<?php
  session_start();
  //mengecek username pada session
  if( !isset($_SESSION['email']) ){
    $_SESSION['msg'] = 'anda harus login untuk mengakses halaman ini';
    header('Location: index.php');
  }
  date_default_timezone_set('Asia/Jakarta');
  include_once 'connection/connect.php';

 
  if (isset($_GET['date'])) {
      $get_date = date("Y-m-d", strtotime($_GET['date']));
      $result = $mysqli->query("
         SELECT id, nomor, waktu, status FROM antrian WHERE DATE(waktu)='$get_date' AND is_close=true ORDER BY id DESC
      ");
  }else{
      $get_date = date('Y-m-d');
      $result = $mysqli->query("
         SELECT id, nomor, waktu, status FROM antrian WHERE DATE(waktu)='$get_date' AND is_close=true ORDER BY id DESC
      ");
    }
?>
<!doctype html>
<html lang="en" class="h-100">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="author" content="boons">

  <!-- Title -->
  <title>Aplikasi Antrian</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-+0n0xVW2eSR5OomGNYDnhzAbDsOXxcvSN1TPprVMTNDbiYZCxYbOOl7+AMvyTG2x" crossorigin="anonymous">
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap4.min.css">
  <link
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"
    rel="stylesheet"/>

  <link
      href="https://code.jquery.com/ui/1.12.1/themes/ui-lightness/jquery-ui.css"
      rel="stylesheet"/>


  <!-- Custom Style -->
  <link rel="stylesheet" href="assets/css/mdb.min.css">
  <link rel="stylesheet" href="assets/css/style.css">

  <style type="text/css">
    .badge {
      --mdb-badge-padding-x: 0.5em !important;
      --mdb-badge-padding-y: 0.5em !important;
    }


    * {
      box-sizing: border-box;
    }
    .select {
      position: relative;
      min-width: 200px;
    }
    .select svg {
      position: absolute;
      right: 12px;
      top: calc(50% - 3px);
      width: 10px;
      height: 6px;
      stroke-width: 2px;
      stroke: #9098a9;
      fill: none;
      stroke-linecap: round;
      stroke-linejoin: round;
      pointer-events: none;
    }
    .select select {
      -webkit-appearance: none;
      padding: 7px 40px 7px 12px;
      width: 100%;
      border: 1px solid #e8eaed;
      border-radius: 5px;
      background: #fff;
      box-shadow: 0 1px 3px -2px #9098a9;
      cursor: pointer;
      font-family: inherit;
      font-size: 16px;
      transition: all 150ms ease;
    }
    .select select:required:invalid {
      color: #5a667f;
    }
    .select select option {
      color: #223254;
    }
    .select select option[value=""][disabled] {
      display: none;
    }
    .select select:focus {
      outline: none;
      border-color: #07f;
      box-shadow: 0 0 0 2px rgba(0,119,255,0.2);
    }
    .select select:hover + svg {
      stroke: #07f;
    }
    .sprites {
      position: absolute;
      width: 0;
      height: 0;
      pointer-events: none;
      user-select: none;
    }

  </style>
</head>

<body class="d-flex flex-column h-100 bd_body">
  <main class="flex-shrink-0">
    <div class="container pt-4">


<!-- Navbar -->
<nav class="navbar navbar-collapse navbar-expand-lg navbar-light bg-light" style="border-radius: 20px !important;">
  <!-- Container wrapper -->
  <div class="container-fluid">
    <!-- Toggle button -->
    <button
      class="navbar-toggler"
      type="button"
      data-mdb-toggle="collapse"
      data-mdb-target="#navbarSupportedContent"
      aria-controls="navbarSupportedContent"
      aria-expanded="false"
      aria-label="Toggle navigation"
    >
      <i class="fas fa-bars"></i>
    </button>

    <!-- Collapsible wrapper -->
    <div class="collapse navbar-collapse" id="navbarSupportedContent">
      <!-- Navbar brand -->
      <a class="navbar-brand mt-2 mt-lg-0" href="#">
        <i class="fa-solid fa-bell text-danger" style="font-size: 40px;"></i>
      </a>
      <!-- Left links -->
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link" href="index.php">Dashboard Antrian</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="kuota.php">Kuota</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="logs.php">Logs</a>
        </li>
      </ul>
      <!-- Left links -->
    </div>
    <!-- Collapsible wrapper -->

    <!-- Right elements -->
    <div class="d-flex align-items-center">
      <!-- Avatar -->
      <div class="dropdown">
        <a
          class="dropdown-toggle d-flex align-items-center hidden-arrow"
          href="#"
          id="navbarDropdownMenuAvatar"
          role="button"
          data-mdb-toggle="dropdown"
          aria-expanded="false"
        >
        Admin  &nbsp;&nbsp;<i class="fa-solid fa-caret-down"></i>
        </a>
        <ul
          class="dropdown-menu dropdown-menu-end"
          aria-labelledby="navbarDropdownMenuAvatar"
        >
          <li>
            <a class="dropdown-item" href="logout.php">Logout</a>
          </li>
        </ul>
      </div>
    </div>
    <!-- Right elements -->
  </div>
  <!-- Container wrapper -->
</nav>
<!-- Navbar -->



      <div class="card border-0 shadow-sm" style="margin-top:20px;">
        <div class="card-body p-4">
          <div class="table-responsive">



    <div class="input-group col-md-12" style="margin-bottom:20px">
        <form action="" method="GET">
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text" id="basic-addon1"><i class="fa-regular fa-calendar-days"></i></span>
          </div>
          <input type="text" id="datepicker" name="date" class="form-control" aria-describedby="basic-addon1">
          <button class="btn btn-primary" style="height: 35px;" type="submit" id="btn_search"><i class="fa-solid fa-magnifying-glass"></i></button>
        </div>
        </form>
    </div>









                    
      <table class="table align-middle mb-0 bg-white" id="table_logs" style="text-align: center;">
        <thead class="bg-light">
            <th style="text-align: center;">Nomor Antrian</th>
            <th style="text-align: center;">Waktu</th>
            <th style="text-align: center;">Status</th>
            <th style="text-align: center;">Actions</th>
        </thead>
        <tbody>
           <?php foreach ($result as $row) : ?>
              <tr id="item_<?php echo $row['id'];?>">
                <td>
                  <?php
                    $statu = $row['status'];
                    $nomor = $row['nomor'];
                    if ($statu == "menunggu") {
                      echo '<span class="badge badge-danger rounded-circle" style="font-size:20px;">'.$nomor.'</span>';
                    }else{
                      echo '<span class="badge badge-success rounded-circle" style="font-size:20px;">'.$nomor.'</span>';
                    }
                  ?>
                </td>
                <td>
                  <?php 
                    $date    = strtotime($row['waktu']);
                    $tanggal = date('d-M-Y', $date);
                    $waktu   = date('H:i', $date);
                    echo '<span class="badge badge-light rounded-pill">'.$tanggal.'</span>&nbsp;';
                    echo '&nbsp;<span class="badge badge-primary rounded-pill">'.$waktu.'</span>';
                  ?>
                <td>
                <?php
                  if ($statu == "menunggu") {
                    echo '<span class="badge badge-warning rounded-pill d-inline" style="font-size:15px;">'.$statu.'</span>';
                  }else{
                    echo '<span class="badge badge-success rounded-pill d-inline" style="font-size:15px;">'.$statu.'</span>';
                  }
                ?>
                </td>
                <td>
                <?php if ($row['status'] == 'menunggu') { ?>
                   <button class="btn btn-danger btn-sm detail btn-rounded" data-id="<?php echo $row['id'] ?>" data-nomor="<?php echo $row['nomor'] ?>"><i class="fa-solid fa-volume-high"></i> Panggil</button>
               <?php  }else{ ?>
                  <button class="btn btn-success btn-sm detail btn-rounded" data-id="<?php echo $row['id'] ?>" data-nomor="<?php echo $row['nomor'] ?>"><i class="fa-solid fa-repeat"></i> Panggil Ulang</button>
                <?php } ?>
              </td>
              </tr>
          <?php endforeach; ?>
        </tbody>
      </table>



          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- load file audio bell antrian -->
  <audio id="tingtung" src="assets/audio/tingtung.mp3"></audio>
  <!-- Footer -->
  <footer class="footer mt-auto py-4">
    <div class="container">
      <hr class="my-4">
      <!-- copyright -->
      <div class="copyright text-center mb-2 mb-md-0">
        &copy; 2022 - <a href="https://antrian.casie.cloud/" target="_blank" class="text-danger text-decoration-none">antrian</a>. All rights reserved.
      </div>
    </div>
  </footer>

  <!-- jQuery Core -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
  <script src="assets/js/mdb.min.js"></script>

  <script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap4.min.js"></script>
  <!-- DataTables JS library -->

  <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
  <!-- Responsivevoice -->
  <!-- Get API Key -> https://responsivevoice.org/ -->
  <script src="https://code.responsivevoice.org/responsivevoice.js?key=jQZ2zcdq"></script>
</body>
<script type="text/javascript">
  $( function() {
    $( "#datepicker" ).datepicker();
  } );

      var getUrlParameter = function getUrlParameter(sParam) {
        var sPageURL = window.location.search.substring(1),
            sURLVariables = sPageURL.split('&'),
            sParameterName,
            i;

        for (i = 0; i < sURLVariables.length; i++) {
            sParameterName = sURLVariables[i].split('=');

            if (sParameterName[0] === sParam) {
                return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
            }
        }
        return false;
    };

    var date = getUrlParameter('date');
    if (date) {
      var realDate = new Date(date);  
      console.log(realDate);
    var myDate = new Date(date);
    $('#datepicker').datepicker();
    $('#datepicker').datepicker('setDate', myDate);
    }

    $(document).ready(function() {
      $('#table_logs').DataTable({
    order: [[0, 'asc']],
    });
  } );


    $(document).on("click",".detail",function() {
        var nomor = $(this).data("nomor");
        var bell = document.getElementById('tingtung');

        // mainkan suara bell antrian
        bell.pause();
        bell.currentTime = 0;
        bell.play();

        // set delay antara suara bell dengan suara nomor antrian
        durasi_bell = bell.duration * 770;

        // mainkan suara nomor antrian
        setTimeout(function() {
          responsiveVoice.speak("Nomor Antrian, " + nomor + ", menuju, loket, 1", "Indonesian Male", {
            rate: 0.9,
            pitch: 1,
            volume: 1
          });
        }, durasi_bell);
    });
</script>
</html>