// web sockets
window.WebSocket = window.WebSocket || window.MozWebSocket;

var connection = new WebSocket('ws://localhost:8080');
var connectingSpan = document.getElementById("connecting");
connection.onopen = function () {
	connectingSpan.style.display = "none";
};
connection.onerror = function (error) {
	connectingSpan.innerHTML = "Error occured";
};


connection.onmessage = function (message) {
	var data = JSON.parse(message.data);
	document.getElementById("jumlah_antrian").innerHTML= data.total_antrian;
	document.getElementById("antrian_menunggu").innerHTML= data.total_menunggu;
	document.getElementById("antrian_selesai").innerHTML= data.total_selesai;
	const monthNames = ["Jan", "Feby", "Mar", "Apr", "May", "Jun",
	  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	];

	if (data.is_update) {
		  var index_row = $("#item_"+data.id+"").index();

		  var x = document.getElementById("tabel-antrian").rows[index_row+1].cells;
		  x[0].innerHTML = "<span class='badge badge-success rounded-circle' style='font-size:20px;'>"+data.nomor+"</span>";
		  x[2].innerHTML = "<span class='badge badge-success rounded-pill d-inline' style='font-size:15px;'>selesai</span>";
		  x[3].innerHTML = "<button class='btn btn-success btn-sm detail btn-rounded' data-id='"+data.id+"' data-nomor='"+data.nomor+"'><i class='fa-solid fa-repeat'></i> Ulang</button>";

		  if (index_row >= 2) {
		  	document.getElementById("tabel-antrian").deleteRow(index_row-1);
		  }
	}else{
		// var table = document.getElementById('tabel-antrian').getElementsByTagName('tbody')[0];
		// var row   = table.insertRow(0);
		// var cell1 = row.insertCell(0);
		// var cell2 = row.insertCell(1);
		// var cell3 = row.insertCell(2);
		// var cell4 = row.insertCell(3);

		const str    = data.waktu;
		const date   = new Date(Date.parse(str));
		var tanggal  = date.getUTCDate()+" "+monthNames[date.getMonth()]+" "+date.getUTCFullYear();
		var waktu    = date.getHours()+":"+date.getMinutes();

	  let table = document.getElementById("tabel-antrian").getElementsByTagName('tbody')[0];

      // Create row element
      let row = document.createElement("tr")
      row.setAttribute("id", "item_"+data.id);
      // Create cells
      let c1 = document.createElement("td")
      let c2 = document.createElement("td")
      let c3 = document.createElement("td")
      let c4 = document.createElement("td")

      // Insert data to cells
      c1.innerHTML = "<span class='badge badge-danger rounded-circle' style='font-size:20px;'>"+data.nomor+"</span>";
      c2.innerHTML = "<span class='badge badge-light rounded-pill'>"+tanggal+"</span>&nbsp;&nbsp;<span class='badge badge-primary rounded-pill'>"+waktu+"</span>";
      c3.innerHTML = "<span class='badge badge-warning rounded-pill d-inline' style='font-size:15px;'>"+data.status+"</span>";
      c4.innerHTML = "<button class='btn btn-danger btn-sm detail btn-rounded' data-id='"+data.id+"' data-nomor='"+data.nomor+"'><i class='fa-solid fa-repeat'></i> Panggil</button>";

      // Append cells to row
      row.appendChild(c1);
      row.appendChild(c2);
      row.appendChild(c3);
      row.appendChild(c4);
      
      // Append row to table body
      table.appendChild(row)

		// cell1.innerHTML = "<span class='badge badge-danger rounded-circle' style='font-size:20px;'>"+data.nomor+"</span>";
		// cell2.innerHTML = "<span class='badge badge-light rounded-pill'>"+tanggal+"</span>&nbsp;&nbsp;<span class='badge badge-primary rounded-pill'>"+waktu+"</span>";
		// cell3.innerHTML = "<span class='badge badge-warning rounded-pill d-inline' style='font-size:15px;'>"+data.status+"</span>";
		// cell4.innerHTML = "<button class='btn btn-danger btn-sm detail btn-rounded' data-id='"+data.id+"' data-nomor='"+data.nomor+"'><i class='fa-solid fa-repeat'></i> Panggil</button>";
	
	    //var tableRef = document.getElementById('tabel-antrian').getElementsByTagName('tbody')[0];
		// $("#tabel-antrian").find('tbody').append("<tr id='item_"+data.id+"'><td><span class='badge badge-danger rounded-circle' style='font-size:20px;'>"+data.nomor+"</span></td>" + 
  //       "<td><span class='badge badge-light rounded-pill'>"+tanggal+"</span>&nbsp;&nbsp;<span class='badge badge-primary rounded-pill'>"+waktu+"</span></td>"+
  //       "<td><span class='badge badge-warning rounded-pill d-inline' style='font-size:15px;'>"+data.status+"</span></td>"+
  //       "<td><button class='btn btn-danger btn-sm detail btn-rounded' data-id='"+data.id+"' data-nomor='"+data.nomor+"'><i class='fa-solid fa-repeat'></i> Panggil</button></td></tr>");


		// tableRef.insertRow().innerHTML = 
  //       "<tr id='item_"+data.id+"'><td><span class='badge badge-danger rounded-circle' style='font-size:20px;'>"+data.nomor+"</span></td>" + 
  //       "<td><span class='badge badge-light rounded-pill'>"+tanggal+"</span>&nbsp;&nbsp;<span class='badge badge-primary rounded-pill'>"+waktu+"</span></td>"+
  //       "<td><span class='badge badge-warning rounded-pill d-inline' style='font-size:15px;'>"+data.status+"</span></td>"+
  //       "<td><button class='btn btn-danger btn-sm detail btn-rounded' data-id='"+data.id+"' data-nomor='"+data.nomor+"'><i class='fa-solid fa-repeat'></i> Panggil</button></td></tr>";


	}
}
